--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;


--
-- Release Notes
-- Version : C.0Ab
-- Updated : 2012/03/23
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ab' WHERE "read_only" = 1 AND "device_type" = 1;
INSERT INTO versionmatch(client_version, compatibility, read_only, device_type) VALUES ('A.0Ab', 1, 1, 3);


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ab';


--
-- Data for Name: imr_scenario; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE imr_scenario ADD COLUMN im_always boolean DEFAULT true;
ALTER TABLE imr_scenario ADD COLUMN im_status integer DEFAULT 0;

--
-- Data for Name: icr_simple_forwarding; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE icr_simple_forwarding ADD COLUMN im_always boolean DEFAULT true;
ALTER TABLE icr_simple_forwarding ADD COLUMN im_status integer DEFAULT 0;

--
-- Data for Name: limitrestriction; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY limitrestriction (property, spec, limitation, minimum, descrip) FROM stdin;
142	1	0	0	Must Change Password at First Login
143	1	0	0	Must Change Password after Password Initialization
144	1	0	0	Do Not Allow the Same Password and User ID
145	999	0	0	Account Lockout Threshold (invalid login attempt times)
146	999	0	0	Account Lockout Duration (minutes)
147	1	0	0	Send Email When User Account is Created
148	999	3	0	Send Email Retry Count
149	999	10	0	Send Email Retry Interval When Failed (minutes)
\.

--
-- Data for Name: clientprofile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE clientprofile ADD COLUMN account_locked boolean DEFAULT false;
ALTER TABLE clientprofile ADD COLUMN locked_duration_dateinf character varying(50);
ALTER TABLE clientprofile ADD COLUMN locked_duration_timeinf character varying(50);
ALTER TABLE clientprofile ADD COLUMN invalid_login_attempts integer DEFAULT 0;
ALTER TABLE clientprofile ADD COLUMN account_disabled boolean DEFAULT false;
ALTER TABLE clientprofile ADD COLUMN must_change_password boolean DEFAULT false;

--
-- Name: email_smtp_server; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE email_smtp_server (
    server_key integer NOT NULL,
    server_address character varying(50) NOT NULL,
    server_port_number integer DEFAULT 25 NOT NULL,
    user_id character varying(50),
    user_password character varying(50),
    use_spa integer DEFAULT 0,
    return_email_address character varying(64)
);


ALTER TABLE public.email_smtp_server OWNER TO postgres;

--
-- Name: email_smtp_server_server_key_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE email_smtp_server_server_key_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.email_smtp_server_server_key_seq OWNER TO postgres;

--
-- Name: email_smtp_server_server_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE email_smtp_server_server_key_seq OWNED BY email_smtp_server.server_key;


--
-- Name: email_smtp_server_server_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('email_smtp_server_server_key_seq', 1, false);


--
-- Name: server_key; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE email_smtp_server ALTER COLUMN server_key SET DEFAULT nextval('email_smtp_server_server_key_seq'::regclass);


--
-- Name: email_smtp_server_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY email_smtp_server
    ADD CONSTRAINT email_smtp_server_pkey PRIMARY KEY (server_key);


--
-- Name: email_useradded; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE email_useradded (
    email_key integer NOT NULL,
    email_title character varying(100),
    email_content character varying(3000),
    replace1 character varying(100),
    replace2 character varying(100),
    replace3 character varying(100),
    replace4 character varying(100)
);


ALTER TABLE public.email_useradded OWNER TO postgres;

--
-- Name: email_useradded_email_key_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE email_useradded_email_key_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.email_useradded_email_key_seq OWNER TO postgres;

--
-- Name: email_useradded_email_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE email_useradded_email_key_seq OWNED BY email_useradded.email_key;


--
-- Name: email_useradded_email_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('email_useradded_email_key_seq', 1, false);


--
-- Name: email_key; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE email_useradded ALTER COLUMN email_key SET DEFAULT nextval('email_useradded_email_key_seq'::regclass);

--
-- Name: email_useradded_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY email_useradded
    ADD CONSTRAINT email_useradded_pkey PRIMARY KEY (email_key);


--
-- Data for Name: email_useradded; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY email_useradded (email_key, email_title, email_content, replace1, replace2, replace3, replace4) FROM stdin;
1	[Notice] UCS Account Created	Dear %userName%\n\nWe are happy to announce that you are now ready to use UCS solution. \n\n* Your ID / Password\n   > "%userID%" / "%userID%" \n* UCS Client Download site\n   > http://your.ucs.server.ipaddress/ucs\n   > Please go and click "download UCS Client" link which provides you with\n        - UCS Client for PC\n        - UCS Client for Android 2.3 or later\n        - UCS Client for Windows Mobile 6.1 or 6.5\n* Security Enhancement\n   > We strongly recommend you to change your default Password for preventing  arbitrary use. \n\n\nSincerely yours\n\nUCS Administrator	\N	\N	\N	\N
\.


--
-- Name: email_sendresult; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE email_sendresult (
    result_key integer NOT NULL,
    kind integer DEFAULT 0,
    client_key integer NOT NULL,
    number_of_trial integer DEFAULT 0,
    current_state integer DEFAULT 0
);


ALTER TABLE public.email_sendresult OWNER TO postgres;

--
-- Name: email_sendresult_result_key_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE email_sendresult_result_key_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.email_sendresult_result_key_seq OWNER TO postgres;

--
-- Name: email_sendresult_result_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE email_sendresult_result_key_seq OWNED BY email_sendresult.result_key;


--
-- Name: email_sendresult_result_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('email_sendresult_result_key_seq', 1, false);


--
-- Name: result_key; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE email_sendresult ALTER COLUMN result_key SET DEFAULT nextval('email_sendresult_result_key_seq'::regclass);


--
-- Name: email_sendresult_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY email_sendresult
    ADD CONSTRAINT email_sendresult_pkey PRIMARY KEY (result_key);


--
-- Name: check_account_lockout(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION check_account_lockout("user" integer) RETURNS clientprofile
    AS $_$DECLARE

    user ALIAS FOR $1;
    lockout_threshold  limitrestriction%ROWTYPE;
    lockout_duration   limitrestriction%ROWTYPE;
    user_clientprofile clientprofile%ROWTYPE;
    
BEGIN
	SELECT * INTO lockout_threshold FROM limitrestriction WHERE property = '145';

	IF lockout_threshold.limitation <> 0 THEN
		SELECT * 
		  INTO user_clientprofile 
		  FROM clientprofile 
		 WHERE client_key = user;

		IF user_clientprofile.invalid_login_attempts < lockout_threshold.limitation THEN
			UPDATE clientprofile 
			   SET invalid_login_attempts=invalid_login_attempts+1 
			 WHERE client_key = user; 

			IF user_clientprofile.invalid_login_attempts+1 = lockout_threshold.limitation THEN
				UPDATE clientprofile 
				   SET account_locked = true 
				 WHERE client_key = user; 

				SELECT * INTO lockout_duration  FROM limitrestriction WHERE property = '146';
				
				IF lockout_duration.limitation <> 0 THEN
					UPDATE clientprofile 
					   SET locked_duration_dateinf = to_char(now() + quote_literal(lockout_duration.limitation || ' minutes')::interval, 'YYYY-MM-DD'),
					   		locked_duration_timeinf = to_char(now() + quote_literal(lockout_duration.limitation || ' minutes')::interval, 'HH24:MI:SS')
					 WHERE client_key = user; 
				ELSE
					UPDATE clientprofile 
					   SET locked_duration_dateinf = '2099-12-31',
					   		locked_duration_timeinf = '23:59:59'
					 WHERE client_key = user; 
				END IF;
			END IF;
		END IF;
	END IF;

	SELECT * 
	  INTO user_clientprofile 
	  FROM clientprofile 
	 WHERE client_key = user;

	RETURN user_clientprofile;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.check_account_lockout("user" integer) OWNER TO postgres;


--
-- Data for Name: adminlevel; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY adminlevel (admin_menu, allowed_admin_level, admin_number) FROM stdin;
E-mail Dispatch	1	318
E-mail Dispatch Result	1	319
User Security Property	1	320
\.


--
-- Release Notes
-- Version : C.0Ae
-- Updated : 2012/05/10
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ae' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Af' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ae';


--
-- Release Notes
-- Version : C.0Ah
-- Updated : 2012/06/18
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ah' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Ah' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ah';


--
-- Data for Name: email_smtp_server; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE email_smtp_server ADD COLUMN connect_type integer DEFAULT 1;

--
-- Data for Name: systeminf; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE systeminf ADD COLUMN mobile_ucs_license integer NOT NULL DEFAULT 0;

--
-- Data for Name: ucuser_profile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE ucuser_profile ADD COLUMN client_device integer DEFAULT 1;

--
-- Release Notes
-- Version : C.0Ai
-- Updated : 2012/07/05
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ai' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Ai' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ai';


--
-- Name: mobile_audio_by_model; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mobile_audio_by_model (
    model_name character varying(80) NOT NULL,
    model_description character varying(80),
    audio_setting_mode integer DEFAULT 2 NOT NULL,
    handset_enable_ns boolean DEFAULT false,
    handset_ns_mode integer DEFAULT 3 NOT NULL,
    handset_enable_agc boolean DEFAULT false,
    handset_agc_mode integer DEFAULT 3 NOT NULL,
    handset_enable_ec boolean DEFAULT true,
    handset_ec_mode integer DEFAULT 5 NOT NULL,
    handset_aecm_mode integer DEFAULT 3 NOT NULL,
    handset_aecm_enable_cng boolean DEFAULT false,
    handset_aes_mode integer DEFAULT 1 NOT NULL,
    handset_aes_saturation integer DEFAULT 28 NOT NULL,
    speaker_enable_ns boolean DEFAULT false,
    speaker_ns_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_agc boolean DEFAULT false,
    speaker_agc_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_ec boolean DEFAULT true,
    speaker_ec_mode integer DEFAULT 4 NOT NULL,
    speaker_aecm_mode integer DEFAULT 3 NOT NULL,
    speaker_aecm_enable_cng boolean DEFAULT false,
    speaker_aes_mode integer DEFAULT 2 NOT NULL,
    speaker_aes_saturation integer DEFAULT 28 NOT NULL
);


ALTER TABLE public.mobile_audio_by_model OWNER TO postgres;

--
-- Name: mobile_audio_by_model_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY mobile_audio_by_model
    ADD CONSTRAINT mobile_audio_by_model_pkey PRIMARY KEY (model_name);


--
-- Name: mobile_audio_by_client; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mobile_audio_by_client (
    client_key integer NOT NULL,
    audio_setting_mode integer DEFAULT 2 NOT NULL,
    handset_enable_ns boolean DEFAULT false,
    handset_ns_mode integer DEFAULT 3 NOT NULL,
    handset_enable_agc boolean DEFAULT false,
    handset_agc_mode integer DEFAULT 3 NOT NULL,
    handset_enable_ec boolean DEFAULT true,
    handset_ec_mode integer DEFAULT 5 NOT NULL,
    handset_aecm_mode integer DEFAULT 3 NOT NULL,
    handset_aecm_enable_cng boolean DEFAULT false,
    handset_aes_mode integer DEFAULT 1 NOT NULL,
    handset_aes_saturation integer DEFAULT 28 NOT NULL,
    speaker_enable_ns boolean DEFAULT false,
    speaker_ns_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_agc boolean DEFAULT false,
    speaker_agc_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_ec boolean DEFAULT true,
    speaker_ec_mode integer DEFAULT 4 NOT NULL,
    speaker_aecm_mode integer DEFAULT 3 NOT NULL,
    speaker_aecm_enable_cng boolean DEFAULT false,
    speaker_aes_mode integer DEFAULT 2 NOT NULL,
    speaker_aes_saturation integer DEFAULT 28 NOT NULL
);


ALTER TABLE public.mobile_audio_by_client OWNER TO postgres;

--
-- Name: mobile_audio_by_client_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY mobile_audio_by_client
    ADD CONSTRAINT mobile_audio_by_client_pkey PRIMARY KEY (client_key);


--
-- Name: make_mobile_audio_by_client(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION make_mobile_audio_by_client()
  RETURNS integer AS
$BODY$DECLARE
    u RECORD;
    t RECORD;
BEGIN
    FOR u IN 
	SELECT 	user_key
	FROM 	userinf
	WHERE   user_key <> 1 AND user_id <> '' AND user_id IS NOT NULL
	LOOP
		INSERT INTO mobile_audio_by_client(client_key)
		    VALUES (u.user_key);
    END LOOP; 
    RETURN 1; 
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION make_mobile_audio_by_client() OWNER TO postgres;

SELECT * FROM make_mobile_audio_by_client();

--
-- Data for Name: ucuser_profile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE ucuser_profile ADD COLUMN model_name character varying(80);


--
-- Data for Name: adminlevel; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY adminlevel (admin_menu, allowed_admin_level, admin_number) FROM stdin;
Audio Setting by Mobile Client	1	321
Audio Setting by Mobile Phone	1	322
\.


--
-- Name: create_audio_setting_by_mobile_phone(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE OR REPLACE FUNCTION create_audio_setting_by_mobile_phone()
  RETURNS integer AS
$BODY$DECLARE
    u RECORD;
    t RECORD;
BEGIN
    FOR u IN 
		SELECT DISTINCT model_name 
		FROM   ucuser_profile 
		WHERE  model_name IS NOT NULL AND 
			   model_name NOT IN ( SELECT model_name FROM mobile_audio_by_model )
		LOOP
			INSERT INTO mobile_audio_by_model(model_name, model_description)
				VALUES (u.model_name, u.model_name);
		END LOOP; 
    RETURN 1; 
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION create_audio_setting_by_mobile_phone() OWNER TO postgres;

--
-- Release Notes
-- Version : 3.0Aj
-- Updated : 2012/07/09
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Aj' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Aj' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Aj';


--
-- Release Notes
-- Version : 3.0Ak
-- Updated : 2012/08/15
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Ak' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Ak' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Ak';


--
-- Data for Name: serveroamoption; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE serveroamoption ADD COLUMN on_demand_backup_request boolean DEFAULT false;


--
-- Release Notes
-- Version : 3.0Am
-- Updated : 2012/09/07
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Am' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Am' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Am';


--
-- PostgreSQL database dump complete
--